<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1999/xhtml">
	<xsl:output method="xml" indent="no"/>
	<xsl:output omit-xml-declaration="yes"/>
	<xsl:variable name="FontFamily" select="'Arial'"/>
	<xsl:variable name="DefaultFontSize" select="'14'"/>
	<xsl:template match="/">
		<xsl:text disable-output-escaping="yes"><![CDATA[<!DOCTYPE html>]]></xsl:text>
		<xsl:text disable-output-escaping="yes">&#xD;</xsl:text>
		<xsl:element name="html">
			<xsl:text disable-output-escaping="yes">&#xD;    </xsl:text>
			<xsl:element name="head">
			<xsl:choose>
				<xsl:when test="/PROJECT/LAYOUT/@REFLOWSTORYDIRECTION = 'VERTICAL'">
					<xsl:text disable-output-escaping="yes">&#xD;<![CDATA[<script type="text/javascript">window.onpageshow=function (){document.body.scrollLeft = document.body.scrollWidth;}</script>]]></xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="/PROJECT/LAYOUT/@TARGETOUTPUTVERSION &gt; '2'">
						<xsl:text disable-output-escaping="yes">&#xD;<![CDATA[<script type="text/javascript"/>]]></xsl:text>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
				<xsl:choose>
					<xsl:when test="/PROJECT/LAYOUT/@TARGETOUTPUTVERSION = '2'">
						<xsl:text disable-output-escaping="yes">&#xD;<![CDATA[<meta http-equiv="Content-Type" content="text/html;charset=UTF-8" />]]></xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text disable-output-escaping="yes">&#xD; <![CDATA[<meta charset="UTF-8" />]]></xsl:text>
					</xsl:otherwise>
				</xsl:choose>
				<!-- &#xD is used to put in a new line -->
				<xsl:if test="/PROJECT/LAYOUT/@REFLOWSTORYDIRECTION = 'VERTICAL'">
					<xsl:text disable-output-escaping="yes">&#xD;    <![CDATA[<link rel="stylesheet" href="vertical_style.css" type="text/css"/>]]></xsl:text>
				</xsl:if>
				<xsl:text disable-output-escaping="yes">&#xD;    <![CDATA[<link rel="stylesheet" href="style.css" type="text/css"/>]]></xsl:text>
				<xsl:text disable-output-escaping="yes">&#xD;    </xsl:text>
				<xsl:element name="title">
					<xsl:apply-templates select="PROJECT/LAYOUT/ARTICLE"/>
				</xsl:element>
				<xsl:text disable-output-escaping="yes">&#xD;  </xsl:text>
			</xsl:element>
			<xsl:element name="body">
				<xsl:attribute name="class">body</xsl:attribute>
				<xsl:choose>
					<xsl:when test="/PROJECT/LAYOUT/@REFLOWSTORYDIRECTION = 'HORIZONTAL'">
						<xsl:apply-templates select="PROJECT/LAYOUT/ARTICLE/COMPONENT"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:element name="div">
							<xsl:attribute name="class"><xsl:value-of select="'component'"/></xsl:attribute>
							<xsl:apply-templates select="PROJECT/LAYOUT/ARTICLE/COMPONENT"/>
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- Sets the title to the Article name of the current box and the corresponding Article which contains it -->
	<xsl:template name="SetTitle" match="ARTICLE">
		<xsl:choose>
			<xsl:when test="../SPREAD/BOX/ID/@NAME = COMPONENT/@BOXNAME">
				<xsl:value-of select="ID/@NAME" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'ePub XHTML made using QuarkXPress'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Removes all escape charecter from node text -->
	<xsl:template name="RemoveEscapes" match="RICHTEXT">
		<xsl:call-template name="RemoveAllEscapes">
			<xsl:with-param name="text" select="."/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="add-line-break">
		<xsl:param name="text"/>
		<xsl:param name="replace" select="'&amp;lineBreak;'"/>
		<xsl:choose>
			<xsl:when test="contains($text, $replace)">
				<xsl:variable name="substringBefore" select="substring-before($text, $replace)"/>
				<xsl:choose>
					<xsl:when test="$substringBefore != $replace">
						<xsl:value-of select="$substringBefore"/>
						<br />
						<xsl:call-template name="add-line-break">
							<xsl:with-param name="text" select="substring-after($text, $replace)"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<br />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Removes all escape charecter from passed text -->
	<xsl:template name="RemoveAllEscapes">
		<xsl:param name="text"/>
		<!-- Replace softRetrun with '&#x0007;' -->
		<xsl:variable name="withoutSoftRetrun">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$text"/>
				<xsl:with-param name="replace" select="'&amp;softReturn;'"/>
				<xsl:with-param name="by" select="'&amp;lineBreak;'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="withoutSoftRetrunSpace">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutSoftRetrun"/>
				<xsl:with-param name="replace" select="'&amp;softReturn ;'"/>
				<xsl:with-param name="by" select="'&amp;lineBreak;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace hardRetrun with '&#x000D;' -->
		<xsl:variable name="withoutHardRetrun">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutSoftRetrunSpace"/>
				<xsl:with-param name="replace" select="'&amp;hardReturn;'"/>
				<xsl:with-param name="by" select="'&#x000D;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace mdash with '&#x2014;' -->
		<xsl:variable name="withoutMdash">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutHardRetrun"/>
				<xsl:with-param name="replace" select="'&amp;mdash;'"/>
				<xsl:with-param name="by" select="'&#x2014;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace ndash with '&#x2013;' -->
		<xsl:variable name="withoutNdash">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutMdash"/>
				<xsl:with-param name="replace" select="'&amp;ndash;'"/>
				<xsl:with-param name="by" select="'&#x2013;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace nbsp with '&#x00A0;' -->
		<xsl:variable name="withoutNbsp">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutNdash"/>
				<xsl:with-param name="replace" select="'&amp;nbsp;'"/>
				<xsl:with-param name="by" select="'&#x00A0;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace ensp with '&#x2002;' -->
		<xsl:variable name="withoutEnsp">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutNbsp"/>
				<xsl:with-param name="replace" select="'&amp;ensp;'"/>
				<xsl:with-param name="by" select="'&#x2002;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace emsp with '&#x2003;' -->
		<xsl:variable name="withoutEmsp">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutEnsp"/>
				<xsl:with-param name="replace" select="'&amp;emsp;'"/>
				<xsl:with-param name="by" select="'&#x2003;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace lineFeed with '&#x000A;' -->
		<xsl:variable name="withoutLineFeed">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutEmsp"/>
				<xsl:with-param name="replace" select="'&amp;nbsp;'"/>
				<xsl:with-param name="by" select="'&#x000A;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace Hyphen with '&#x2010;' -->
		<xsl:variable name="withoutHyphen">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutLineFeed"/>
				<xsl:with-param name="replace" select="'&amp;hyphen;'"/>
				<xsl:with-param name="by" select="'&#x2010;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace hTab with '&#x0009;' -->
		<xsl:variable name="withoutHtab">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutHyphen"/>
				<xsl:with-param name="replace" select="'&amp;hTab;'"/>
				<xsl:with-param name="by" select="'&#x0009;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace punctSpace with '&#x2008;' -->
		<xsl:variable name="withoutPunctSpace">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutHtab"/>
				<xsl:with-param name="replace" select="'&amp;punctSpace;'"/>
				<xsl:with-param name="by" select="'&#x2008;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace etx with '&#x0003;' -->
		<xsl:variable name="withoutEtx">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutPunctSpace"/>
				<xsl:with-param name="replace" select="'&amp;etx;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace eot with '&#x0004;' -->
		<xsl:variable name="withoutEot">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutEtx"/>
				<xsl:with-param name="replace" select="'&amp;eot;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace enq with '&#x0005;' -->
		<xsl:variable name="withoutEnq">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutEot"/>
				<xsl:with-param name="replace" select="'&amp;enq;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace ack with '&#x0006;' -->
		<xsl:variable name="withoutAck">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutEnq"/>
				<xsl:with-param name="replace" select="'&amp;ack;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace bs with '&#x0008;' -->
		<xsl:variable name="withoutBs">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutAck"/>
				<xsl:with-param name="replace" select="'&amp;bs;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace vTab with '&#x000B;' -->
		<xsl:variable name="withoutVtab">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutBs"/>
				<xsl:with-param name="replace" select="'&amp;vTab;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace boxBreak with '&#x000C;' -->
		<xsl:variable name="withoutBoxBreak">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutVtab"/>
				<xsl:with-param name="replace" select="'&amp;boxBreak;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace so with '&#x000E;' -->
		<xsl:variable name="withoutSo">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutBoxBreak"/>
				<xsl:with-param name="replace" select="'&amp;so;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace flexSpace with '&#x000F;' -->
		<xsl:variable name="withoutFlexSpace">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutSo"/>
				<xsl:with-param name="replace" select="'&amp;flexSpace;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace dle with '&#x0010;' -->
		<xsl:variable name="withoutDle">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutFlexSpace"/>
				<xsl:with-param name="replace" select="'&amp;dle;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace dcOne with '&#x0011;' -->
		<xsl:variable name="withoutDcOne">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutDle"/>
				<xsl:with-param name="replace" select="'&amp;dcOne;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace dcTwo with '&#x0012;' -->
		<xsl:variable name="withoutDcTwo">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutDcOne"/>
				<xsl:with-param name="replace" select="'&amp;dcTwo;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace dcThree with '&#x0013;' -->
		<xsl:variable name="withoutDcThree">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutDcTwo"/>
				<xsl:with-param name="replace" select="'&amp;dcThree;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace dcFour with '&#x0014;' -->
		<xsl:variable name="withoutDcFour">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutDcThree"/>
				<xsl:with-param name="replace" select="'&amp;dcFour;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace nak with '&#x0015;' -->
		<xsl:variable name="withoutNak">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutDcFour"/>
				<xsl:with-param name="replace" select="'&amp;nak;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace syn with '&#x0016;' -->
		<xsl:variable name="withoutSyn">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutNak"/>
				<xsl:with-param name="replace" select="'&amp;syn;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace etb with '&#x0017;' -->
		<xsl:variable name="withoutEtb">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutSyn"/>
				<xsl:with-param name="replace" select="'&amp;etb;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace can with '&#x0018;' -->
		<xsl:variable name="withoutCan">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutEtb"/>
				<xsl:with-param name="replace" select="'&amp;can;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace em with '&#x0019;' -->
		<xsl:variable name="withoutEm">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutCan"/>
				<xsl:with-param name="replace" select="'&amp;em;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace sub with '&#x001A;' -->
		<xsl:variable name="withoutSub">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutEm"/>
				<xsl:with-param name="replace" select="'&amp;sub;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace esc with '&#x001B;' -->
		<xsl:variable name="withoutEsc">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutSub"/>
				<xsl:with-param name="replace" select="'&amp;esc;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace fs with '&#x001C;' -->
		<xsl:variable name="withoutFs">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutEsc"/>
				<xsl:with-param name="replace" select="'&amp;fs;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace discReturn with '&#x001D;' -->
		<xsl:variable name="withoutDiscReturn">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutFs"/>
				<xsl:with-param name="replace" select="'&amp;discReturn;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace indentHere with '&#x001E;' -->
		<xsl:variable name="withoutIndentHere">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutDiscReturn"/>
				<xsl:with-param name="replace" select="'&amp;indentHere;'"/>
				<xsl:with-param name="by" select="'    '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace shy with '&#x001F;' -->
		<xsl:variable name="withoutShy">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutIndentHere"/>
				<xsl:with-param name="replace" select="'&amp;shy;'"/>
				<xsl:with-param name="by" select="' '"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace threePerEmSpace with '&#x2004;' -->
		<xsl:variable name="withoutThreePerEmSpace">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutShy"/>
				<xsl:with-param name="replace" select="'&amp;threePerEmSpace;'"/>
				<xsl:with-param name="by" select="'&#x2004;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace fourPerEmSpace with '&#x2005;' -->
		<xsl:variable name="withoutFourPerEmSpace">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutThreePerEmSpace"/>
				<xsl:with-param name="replace" select="'&amp;fourPerEmSpace;'"/>
				<xsl:with-param name="by" select="'&#x2005;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace sixPerEmSpace with '&#x2006;' -->
		<xsl:variable name="withoutSixPerEmSpace">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutFourPerEmSpace"/>
				<xsl:with-param name="replace" select="'&amp;sixPerEmSpace;'"/>
				<xsl:with-param name="by" select="'&#x2006;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace figureSpace with '&#x2007;' -->
		<xsl:variable name="withoutFigureSpaceSpace">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutSixPerEmSpace"/>
				<xsl:with-param name="replace" select="'&amp;figureSpace;'"/>
				<xsl:with-param name="by" select="'&#x2007;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace thinsp with '&#x2009;' -->
		<xsl:variable name="withoutThinsp">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutFigureSpaceSpace"/>
				<xsl:with-param name="replace" select="'&amp;thinsp;'"/>
				<xsl:with-param name="by" select="'&#x2009;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace hairSpace with '&#x200A;' -->
		<xsl:variable name="withoutHairSpace">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutThinsp"/>
				<xsl:with-param name="replace" select="'&amp;hairSpace;'"/>
				<xsl:with-param name="by" select="'&#x200A;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace zeroWidthSpace with '&#x200B;' -->
		<xsl:variable name="withoutZeroWidthSpace">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutHairSpace"/>
				<xsl:with-param name="replace" select="'&amp;zeroWidthSpace;'"/>
				<xsl:with-param name="by" select="'&#x200B;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace wordJoiner with '&#x2060;' -->
		<xsl:variable name="withoutWordJoiner">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutZeroWidthSpace"/>
				<xsl:with-param name="replace" select="'&amp;wordJoiner;'"/>
				<xsl:with-param name="by" select="'&#x2060;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace ideographicSpace with '&#x3000;' -->
		<xsl:variable name="withoutIdeographicSpace">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutWordJoiner"/>
				<xsl:with-param name="replace" select="'&amp;ideographicSpace;'"/>
				<xsl:with-param name="by" select="'&#x3000;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Replace discHyphen with '&#x00AD;' -->
		<xsl:variable name="withoutDiscHyphen">
			<xsl:call-template name="replace-text">
				<xsl:with-param name="text" select="$withoutIdeographicSpace"/>
				<xsl:with-param name="replace" select="'&amp;discHyphen;'"/>
				<xsl:with-param name="by" select="'&#x00AD;'"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Write the final modified text -->
		<xsl:call-template name="add-line-break">
			<xsl:with-param name="text" select="$withoutDiscHyphen"/>
		</xsl:call-template>
	</xsl:template>
	<!-- Search specified text and replaces text with passed text -->
	<xsl:template name="replace-text">
		<xsl:param name="text"/>
		<xsl:param name="replace"/>
		<xsl:param name="by"/>
		<xsl:choose>
			<xsl:when test="contains($text, $replace)">
				<xsl:variable name="substringBefore" select="substring-before($text, $replace)"/>
				<xsl:choose>
					<xsl:when test="$substringBefore != $replace">
						<xsl:value-of select="$substringBefore"/>
						<xsl:value-of select="$by" disable-output-escaping="no"/>
						<xsl:call-template name="replace-text">
							<xsl:with-param name="text" select="substring-after($text, $replace)"/>
							<xsl:with-param name="replace" select="$replace"/>
							<xsl:with-param name="by" select="$by"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$by"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Component template iterates all components and pass component boxuid to Spread template -->
	<xsl:template name="Component" match="COMPONENT">
		<xsl:apply-templates select="../../SPREAD">
			<xsl:with-param name="compBoxUID" select="@BOXUID"/>
			<xsl:with-param name="fontFamily" select="$FontFamily"/>
			<xsl:with-param name="fontSize" select="$DefaultFontSize"/>
			<xsl:with-param name="textIndent" select="0"/>
			<xsl:with-param name="textAlignment" select="'Left'"/>
		</xsl:apply-templates>
	</xsl:template>
	<!-- Spread template iterates all Boxes and call Box template -->
	<xsl:template name="Spread" match="SPREAD">
		<xsl:param name="compBoxUID" select="'$compBoxUID'"/>
		<xsl:param name="fontFamily" select="$FontFamily"/>
		<xsl:param name="fontSize" select="$fontSize"/>
		<xsl:param name="textIndent" select="$textIndent"/>
		<xsl:param name="textAlignment" select="$textAlignment"/>
		<xsl:if test="BOX/ID/@UID = $compBoxUID">
			<xsl:apply-templates select="BOX">
				<xsl:with-param name="compBoxUID" select="$compBoxUID"/>
				<xsl:with-param name="fontFamily" select="$FontFamily"/>
				<xsl:with-param name="fontSize" select="$fontSize"/>
				<xsl:with-param name="textIndent" select="$textIndent"/>
				<xsl:with-param name="textAlignment" select="$textAlignment"/>
				<xsl:with-param name="anchBox" select="'false'"/>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template>
	<!-- Box template iterates all Boxes and call Picture/Paragraph template -->
	<xsl:template name="Box" match="BOX | GROUP | TABLE">
		<xsl:param name="compBoxUID" select="'$compBoxUID'"/>
		<xsl:param name="fontFamily" select="$FontFamily"/>
		<xsl:param name="fontSize" select="$fontSize"/>
		<xsl:param name="textIndent" select="$textIndent"/>
		<xsl:param name="textAlignment" select="$textAlignment"/>
		<xsl:param name="anchBox" select="$anchBox"/>
		<xsl:if test="ID/@UID = $compBoxUID">
			<xsl:if test="TEXT">
				<xsl:apply-templates select="TEXT/STORY/PARAGRAPH | 	TEXT/STORY/OVERMATTER/PARAGRAPH">
					<xsl:with-param name="pageID" select="GEOMETRY/@PAGE - 1"/>
					<xsl:with-param name="fontFamily" select="$FontFamily"/>
					<xsl:with-param name="fontSize" select="$fontSize"/>
					<xsl:with-param name="textIndent" select="$textIndent"/>
					<xsl:with-param name="textAlignment" select="$textAlignment"/>
					<xsl:with-param name="anchBox" select="$anchBox"/>
				</xsl:apply-templates>
			</xsl:if>
			<xsl:if test="PICTURE">
				<xsl:variable name="Top" select="./GEOMETRY/POSITION/TOP"/>
				<xsl:variable name="Bottom" select="./GEOMETRY/POSITION/BOTTOM"/>
				<xsl:variable name="Right" select="./GEOMETRY/POSITION/RIGHT"/>
				<xsl:variable name="Left" select="./GEOMETRY/POSITION/LEFT"/>
				<!--xsl:if test="CONTENT != ''"-->
				<xsl:apply-templates select="PICTURE">
					<xsl:with-param name="imageSource" select="$compBoxUID"/>
					<xsl:with-param name="imageWidth" select="$Right - $Left"/>
					<xsl:with-param name="imageHeight" select="$Bottom - $Top"/>
					<xsl:with-param name="anchBox" select="$anchBox"/>
				</xsl:apply-templates>
				<!--/xsl:if-->
			</xsl:if>
			<xsl:if test="local-name() = 'GROUP' or local-name() = 'TABLE' or 	@BOXTYPE='CT_NONE'">
				<xsl:variable name="Top" select="./GEOMETRY/POSITION/TOP"/>
				<xsl:variable name="Bottom" select="./GEOMETRY/POSITION/BOTTOM"/>
				<xsl:variable name="Right" select="./GEOMETRY/POSITION/RIGHT"/>
				<xsl:variable name="Left" select="./GEOMETRY/POSITION/LEFT"/>
				<xsl:element name="img">
					<xsl:choose>
						<xsl:when test="../@EXPORTREFLOWPICAS = 'JPEG'">
							<xsl:attribute name="src"><xsl:value-of select="concat('images/', 	$compBoxUID, '.jpg')"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="src"><xsl:value-of select="concat('images/', 	$compBoxUID, '.png')"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="width"><xsl:value-of select="$Right - $Left"/></xsl:attribute>
					<xsl:attribute name="height"><xsl:value-of select="$Bottom - $Top"/></xsl:attribute>
				</xsl:element>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!-- Added info related to picture component -->
	<xsl:template name="PictureComponent" match="PICTURE">
		<xsl:param name="imageSource" select="$imageSource"/>
		<xsl:param name="imageWidth" select="$imageWidth"/>
		<xsl:param name="imageHeight" select="$imageHeight"/>
		<xsl:param name="anchBox" select="$anchBox"/>
		<xsl:choose>
			<xsl:when test="$anchBox = 'false'">
				<xsl:element name="p">
					<xsl:choose>
						<xsl:when test="../INTERACTIVITY">
							<xsl:attribute name="class">figure</xsl:attribute>
							<xsl:call-template name="AnObject">
								<xsl:with-param name="BoxID" select="../ID/@UID"/>
								<xsl:with-param name="imageSource" select="$imageSource"/>
								<xsl:with-param name="imageWidth" select="$imageWidth"/>
								<xsl:with-param name="imageHeight" select="$imageHeight"/>
								<xsl:with-param name="Interactivity" select="../INTERACTIVITY/@TYPE"/>
								<xsl:with-param name="Data" select="../INTERACTIVITY/DATAPROVIDER/DIGITALPUBLISHING.DATAPROVIDER/DIGITALPUBLISHING.DATAPROVIDER.FILEPATH"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">figure</xsl:attribute>
							<xsl:if test="../@HLANCHORREF">
								<xsl:element name="a">
									<xsl:attribute name="id"><xsl:value-of select="../@HLANCHORREF"/></xsl:attribute>
								</xsl:element>
							</xsl:if>
							<xsl:if test="../@HYPERLINKREF and (../@HLTYPE='WWWURL' or ../@HLTYPE='ANCHOR')">
								<xsl:element name="a">
									<xsl:attribute name="href"><xsl:value-of select="../@HYPERLINKREF"/></xsl:attribute>
									<xsl:call-template name="Picture">
										<xsl:with-param name="imageSource" select="$imageSource"/>
										<xsl:with-param name="imageWidth" select="$imageWidth"/>
										<xsl:with-param name="imageHeight" select="$imageHeight"/>
									</xsl:call-template>
								</xsl:element>
							</xsl:if>
							<xsl:if test="not(../@HYPERLINKREF) or (../@HLTYPE='PAGE')">
								<xsl:call-template name="Picture">
									<xsl:with-param name="imageSource" select="$imageSource"/>
									<xsl:with-param name="imageWidth" select="$imageWidth"/>
									<xsl:with-param name="imageHeight" select="$imageHeight"/>
								</xsl:call-template>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="Picture">
					<xsl:with-param name="imageSource" select="$imageSource"/>
					<xsl:with-param name="imageWidth" select="$imageWidth"/>
					<xsl:with-param name="imageHeight" select="$imageHeight"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Added info related to picture component -->
	<xsl:template name="AnObject">
		<xsl:param name="BoxID" select="$BoxID"/>
		<xsl:param name="imageSource" select="$imageSource"/>
		<xsl:param name="imageWidth" select="$imageWidth"/>
		<xsl:param name="imageHeight" select="$imageHeight"/>
		<xsl:param name="Interactivity" select="$Interactivity"/>
		<xsl:param name="Data" select="$Data"/>
		<xsl:choose>
			<xsl:when test="$Interactivity = 'Video'">
				<xsl:element name="video">
					<xsl:attribute name="id"><xsl:value-of select="$BoxID"/></xsl:attribute>
					<xsl:attribute name="src"><xsl:call-template name="ResourcePath"><xsl:with-param name="imagePath" select="$Data"/></xsl:call-template></xsl:attribute>
					<xsl:if test="local-name()='PICTURE' and following-sibling::CONTENT[1]">
						<xsl:attribute name="poster"><xsl:choose><xsl:when test="../@EXPORTREFLOWPICAS = 'JPEG'"><xsl:call-template name="ResourcePath"><xsl:with-param name="imagePath" select="concat($imageSource,'.jpg')"/></xsl:call-template></xsl:when><xsl:otherwise><xsl:call-template name="ResourcePath"><xsl:with-param name="imagePath" select="concat($imageSource,'.png')"/></xsl:call-template></xsl:otherwise></xsl:choose></xsl:attribute>
					</xsl:if>
					<xsl:attribute name="controls"><xsl:value-of select="controls"/></xsl:attribute>
					<xsl:call-template name="Picture">
						<xsl:with-param name="imageSource" select="$imageSource"/>
						<xsl:with-param name="imageWidth" select="$imageWidth"/>
						<xsl:with-param name="imageHeight" select="$imageHeight"/>
					</xsl:call-template>
					<xsl:element name="br"/>
                                         Video Not Supported!!
				</xsl:element>
			</xsl:when>
			<xsl:when test="$Interactivity = 'Audio'">
				<xsl:element name="audio">
					<xsl:attribute name="id"><xsl:value-of select="$BoxID"/></xsl:attribute>
					<xsl:attribute name="src"><xsl:value-of select="concat('images/', $Data)"/></xsl:attribute>
					<xsl:attribute name="controls"><xsl:value-of select="controls"/></xsl:attribute>
						Audio Not Supported!!
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="p">
					<xsl:call-template name="Picture">
						<xsl:with-param name="imageSource" select="$imageSource"/>
						<xsl:with-param name="imageWidth" select="$imageWidth"/>
						<xsl:with-param name="imageHeight" select="$imageHeight"/>
					</xsl:call-template>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Picture">
		<xsl:param name="imageSource" select="$imageSource"/>
		<xsl:param name="imageWidth" select="$imageWidth"/>
		<xsl:param name="imageHeight" select="$imageHeight"/>
		<xsl:if test="following-sibling::CONTENT[1]">
			<xsl:element name="img">
				<xsl:choose>
					<xsl:when test="../@EXPORTREFLOWPICAS = 'JPEG'">
						<xsl:attribute name="src"><xsl:value-of select="concat('images/', $imageSource, '.jpg')"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="src"><xsl:value-of select="concat('images/', $imageSource, '.png')"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:attribute name="width"><xsl:value-of select="round($imageWidth)"/></xsl:attribute>
				<xsl:attribute name="height"><xsl:value-of select="round($imageHeight)"/></xsl:attribute>
				<xsl:attribute name="alt"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- Parse picture filepath and extract file name only -->
	<xsl:template name="ResourcePath">
		<xsl:param name="imagePath" select="$imagePath"/>
		<xsl:choose>
			<xsl:when test="contains($imagePath, '/')">
				<xsl:call-template name="ResourcePath">
					<xsl:with-param name="imagePath" select="substring-after($imagePath, '/')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="contains($imagePath, '\')">
						<xsl:call-template name="ResourcePath">
							<xsl:with-param name="imagePath" select="substring-after($imagePath, '\')"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="contains($imagePath, ':')">
								<xsl:call-template name="ResourcePath">
									<xsl:with-param name="imagePath" select="substring-after($imagePath, ':')"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat('images/', $imagePath)"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Added info related to text component -->
	<xsl:template name="TextComponent" match="PARAGRAPH">
		<xsl:param name="pageID" select="$pageID"/>
		<xsl:param name="fontFamily" select="$FontFamily"/>
		<xsl:param name="fontSize" select="$fontSize"/>
		<xsl:param name="textIndent" select="$textIndent"/>
		<xsl:param name="textAlignment" select="$textAlignment"/>
		<xsl:param name="anchBox" select="$anchBox"/>
		<xsl:if test="@TOCEPUBHREF">
			<xsl:element name="p">
				<xsl:element name="span">
					<xsl:attribute name="id"><xsl:value-of select="@TOCEPUBHREF"/></xsl:attribute>
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:variable name="localAnchBox">
			<xsl:choose>
				<xsl:when test="$anchBox = 'true'">
					<xsl:choose>
						<xsl:when test="position() = 1">
							<xsl:text disable-output-escaping="yes">yes</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text disable-output-escaping="yes">false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text disable-output-escaping="yes">false</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$localAnchBox = 'false'">
				<xsl:element name="p">
					<xsl:attribute name="style"><xsl:choose><xsl:when test="/PROJECT/LAYOUT/@REFLOWSTORYDIRECTION = 'VERTICAL'"><xsl:value-of select="'padding-top:'"/></xsl:when><xsl:otherwise><xsl:value-of select="'padding-left:'"/></xsl:otherwise></xsl:choose><xsl:if test="@INDENTLEVEL"><xsl:value-of select="30+25*@INDENTLEVEL "/></xsl:if><xsl:if test="not(@INDENTLEVEL)"><xsl:value-of select="'30'"/></xsl:if><xsl:value-of select="'px;'"/><xsl:if test="not(FORMAT/BNSTYLE/@NAME='None')"><xsl:if test="string-length(FORMAT/BNSTYLE/@BNCHAR)='1'"><xsl:value-of select="'text-indent:-17px'"/></xsl:if><xsl:if test="string-length(FORMAT/BNSTYLE/@BNCHAR)>'1'"><xsl:value-of select="'text-indent:'"/><xsl:value-of select="-20-3*string-length(FORMAT/BNSTYLE/@BNCHAR)"/><xsl:value-of select="'px'"/></xsl:if></xsl:if></xsl:attribute>
					<xsl:call-template name="Paragraph">
						<xsl:with-param name="pageID" select="$pageID"/>
						<xsl:with-param name="fontFamily" select="$FontFamily"/>
						<xsl:with-param name="fontSize" select="$fontSize"/>
						<xsl:with-param name="textIndent" select="$textIndent"/>
						<xsl:with-param name="textAlignment" select="$textAlignment"/>
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="Paragraph">
					<xsl:with-param name="pageID" select="$pageID"/>
					<xsl:with-param name="fontFamily" select="$FontFamily"/>
					<xsl:with-param name="fontSize" select="$fontSize"/>
					<xsl:with-param name="textIndent" select="$textIndent"/>
					<xsl:with-param name="textAlignment" select="$textAlignment"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Added info related to text component -->
	<xsl:template name="Paragraph">
		<xsl:param name="pageID" select="'$pageID'"/>
		<xsl:param name="fontFamily" select="$FontFamily"/>
		<xsl:param name="fontSize" select="$fontSize"/>
		<xsl:param name="textIndent" select="$textIndent"/>
		<xsl:param name="textAlignment" select="$textAlignment"/>
		<xsl:variable name="paraClass">
			<!-- We are not going to handle 'Body' tag type as that is the style which will always be applied as default style-->
			<xsl:choose>
				<xsl:when test="@TEXTTAGTYPE">
					<xsl:if test="'Byline' = @TEXTTAGTYPE">
						<xsl:text disable-output-escaping="yes">byline</xsl:text>
					</xsl:if>
					<xsl:if test="'FigureCaption' = @TEXTTAGTYPE">
						<xsl:text disable-output-escaping="yes">figure-caption</xsl:text>
					</xsl:if>
					<xsl:if test="'FigureCredit' = @TEXTTAGTYPE">
						<xsl:text disable-output-escaping="yes">figure-credit</xsl:text>
					</xsl:if>
					<xsl:if test="'Headline1' = @TEXTTAGTYPE">
						<xsl:text disable-output-escaping="yes">headline1</xsl:text>
					</xsl:if>
					<xsl:if test="'Headline2' = @TEXTTAGTYPE">
						<xsl:text disable-output-escaping="yes">headline2</xsl:text>
					</xsl:if>
					<xsl:if test="'IndentedParagraph' = @TEXTTAGTYPE">
						<xsl:text disable-output-escaping="yes">indented-para</xsl:text>
					</xsl:if>
					<xsl:if test="'Pullquote' = @TEXTTAGTYPE">
						<xsl:text disable-output-escaping="yes">pullquote</xsl:text>
					</xsl:if>
					<xsl:if test="'SectionChapterName' = @TEXTTAGTYPE">
						<xsl:text disable-output-escaping="yes">chapter-name</xsl:text>
					</xsl:if>
					<xsl:if test="'Title1' = @TEXTTAGTYPE">
						<xsl:text disable-output-escaping="yes">title1</xsl:text>
					</xsl:if>
					<xsl:if test="'Title2' = @TEXTTAGTYPE">
						<xsl:text disable-output-escaping="yes">title2</xsl:text>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text disable-output-escaping="yes"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="'' != $paraClass">
			<xsl:attribute name="class"><xsl:value-of select="$paraClass"/></xsl:attribute>
		</xsl:if>
		<xsl:for-each select="*">
			<xsl:if test="local-name() = 'RICHTEXT'">
				<xsl:if test="@HLANCHORREF">
					<xsl:element name="a">
						<xsl:attribute name="id"><xsl:value-of select="@HLANCHORREF"/></xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:if test="@HYPERLINKREF and (@HLTYPE='WWWURL' or @HLTYPE='ANCHOR')">
					<xsl:element name="a">
						<xsl:attribute name="href"><xsl:value-of select="@HYPERLINKREF"/></xsl:attribute>
						<xsl:value-of select="."/>
					</xsl:element>
				</xsl:if>
				<xsl:if test="@HYPERLINKREF and @HLTYPE='PAGE'">
					<xsl:element name="span">
						<xsl:value-of select="."/>
					</xsl:element>
				</xsl:if>
				<xsl:if test="not(@HYPERLINKREF)">
					<xsl:call-template name="RICHTEXT">
						<xsl:with-param name="pageID" select="$pageID"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:if>
			<xsl:if test="local-name() = 'FORMAT'">
				<xsl:call-template name="FORMAT"/>
			</xsl:if>
			<xsl:if test="local-name() = 'GROUPCHARACTERS'">
				<xsl:choose>
					<xsl:when test="/PROJECT/LAYOUT/@REFLOWSTORYDIRECTION = 'HORIZONTAL'">
						<xsl:apply-templates select="./RICHTEXT">
							<xsl:with-param name="pageID" select="$pageID"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:element name="span">
							<xsl:attribute name="class"><xsl:value-of select="'tyc'"/></xsl:attribute>
							<xsl:apply-templates select="./RICHTEXT">
								<xsl:with-param name="pageID" select="$pageID"/>
								<xsl:with-param name="isTyc" select="'true'"/>
							</xsl:apply-templates>
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="local-name() = 'RUBI'">
				<xsl:apply-templates select=".">
					<xsl:with-param name="pageID" select="$pageID"/>
				</xsl:apply-templates>
			</xsl:if>
			<xsl:if test="local-name() = 'ANCHOREDBOXREF'">
				<xsl:variable name="anchCompBoxUID" select="@BOXUID"/>
				<xsl:variable name="anchBox">
					<xsl:choose>
						<xsl:when test="(../preceding-sibling::PARAGRAPH)">
							<xsl:text disable-output-escaping="yes">true</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text disable-output-escaping="yes">false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:apply-templates select="/PROJECT/LAYOUT/SPREAD/BOX | /PROJECT/LAYOUT/SPREAD/GROUP | /PROJECT/LAYOUT/SPREAD/TABLE">
					<xsl:with-param name="compBoxUID" select="$anchCompBoxUID"/>
					<xsl:with-param name="fontFamily" select="$FontFamily"/>
					<xsl:with-param name="fontSize" select="$fontSize"/>
					<xsl:with-param name="textIndent" select="$textIndent"/>
					<xsl:with-param name="textAlignment" select="$textAlignment"/>
					<xsl:with-param name="anchBox" select="$anchBox"/>
				</xsl:apply-templates>
			</xsl:if>
			<xsl:if test="local-name() = 'CALLOUTANCHOR'">
				<xsl:variable name="anchCompBoxUID" select="./CALLOUTBOXREF/@UID"/>
				<xsl:variable name="anchBox">
					<xsl:choose>
						<xsl:when test="(../preceding-sibling::PARAGRAPH)">
							<xsl:text disable-output-escaping="yes">true</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text disable-output-escaping="yes">false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:apply-templates select="/PROJECT/LAYOUT/SPREAD/BOX | /PROJECT/LAYOUT/SPREAD/GROUP | /PROJECT/LAYOUT/SPREAD/TABLE">
					<xsl:with-param name="compBoxUID" select="$anchCompBoxUID"/>
					<xsl:with-param name="fontFamily" select="$FontFamily"/>
					<xsl:with-param name="fontSize" select="$fontSize"/>
					<xsl:with-param name="textIndent" select="$textIndent"/>
					<xsl:with-param name="textAlignment" select="$textAlignment"/>
					<xsl:with-param name="anchBox" select="$anchBox"/>
				</xsl:apply-templates>
			</xsl:if>
			<xsl:if test="position()=last() and not(../following-sibling::PARAGRAPH)">
				<xsl:if test="../../OVERMATTER">
					<xsl:for-each select="../../OVERMATTER/*">
						<xsl:if test="local-name() = 'RICHTEXT'">
							<xsl:if test="@HLANCHORREF">
								<xsl:element name="a">
									<xsl:attribute name="id"><xsl:value-of select="@HLANCHORREF"/></xsl:attribute>
								</xsl:element>
							</xsl:if>
							<xsl:if test="@HYPERLINKREF and (@HLTYPE='WWWURL' or @HLTYPE='ANCHOR')">
								<xsl:element name="a">
									<xsl:attribute name="href"><xsl:value-of select="@HYPERLINKREF"/></xsl:attribute>
									<xsl:value-of select="."/>
								</xsl:element>
							</xsl:if>
							<xsl:if test="@HYPERLINKREF and @HLTYPE='PAGE'">
								<xsl:element name="span">
									<xsl:value-of select="."/>
								</xsl:element>
							</xsl:if>
							<xsl:if test="not(@HYPERLINKREF)">
								<xsl:call-template name="RICHTEXT">
									<xsl:with-param name="pageID" select="$pageID"/>
								</xsl:call-template>
							</xsl:if>
						</xsl:if>
						<xsl:if test="local-name() = 'GROUPCHARACTERS'">
							<xsl:choose>
								<xsl:when test="/PROJECT/LAYOUT/@REFLOWSTORYDIRECTION = 			'HORIZONTAL'">
									<xsl:apply-templates select="./RICHTEXT">
										<xsl:with-param name="pageID" select="$pageID"/>
									</xsl:apply-templates>
								</xsl:when>
								<xsl:otherwise>
									<xsl:element name="span">
										<xsl:attribute name="class"><xsl:value-of select="'tyc'"/></xsl:attribute>
										<xsl:apply-templates select="./RICHTEXT">
											<xsl:with-param name="pageID" select="$pageID"/>
											<xsl:with-param name="isTyc" select="'true'"/>
										</xsl:apply-templates>
									</xsl:element>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
						<xsl:if test="local-name() = 'RUBI'">
							<xsl:apply-templates select=".">
								<xsl:with-param name="pageID" select="$pageID"/>
							</xsl:apply-templates>
						</xsl:if>
						<xsl:if test="local-name() = 'ANCHOREDBOXREF'">
							<xsl:variable name="anchCompBoxUID" select="@BOXUID"/>
							<xsl:variable name="anchBox">
								<xsl:choose>
									<xsl:when test="(../preceding-sibling::PARAGRAPH)">
										<xsl:text disable-output-escaping="yes">true</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text disable-output-escaping="yes">false</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:apply-templates select="/PROJECT/LAYOUT/SPREAD/BOX | /PROJECT/LAYOUT/SPREAD/GROUP | /PROJECT/LAYOUT/SPREAD/TABLE">
								<xsl:with-param name="compBoxUID" select="$anchCompBoxUID"/>
								<xsl:with-param name="fontFamily" select="$FontFamily"/>
								<xsl:with-param name="fontSize" select="$fontSize"/>
								<xsl:with-param name="textIndent" select="$textIndent"/>
								<xsl:with-param name="textAlignment" select="$textAlignment"/>
								<xsl:with-param name="anchBox" select="$anchBox"/>
							</xsl:apply-templates>
						</xsl:if>
						<xsl:if test="local-name() = 'CALLOUTANCHOR'">
							<xsl:variable name="anchCompBoxUID" select="./CALLOUTBOXREF/@UID"/>
							<xsl:variable name="anchBox">
								<xsl:choose>
									<xsl:when test="(../preceding-sibling::PARAGRAPH)">
										<xsl:text disable-output-escaping="yes">true</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:text disable-output-escaping="yes">false</xsl:text>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<xsl:apply-templates select="/PROJECT/LAYOUT/SPREAD/BOX | /PROJECT/LAYOUT/SPREAD/GROUP | /PROJECT/LAYOUT/SPREAD/TABLE">
								<xsl:with-param name="compBoxUID" select="$anchCompBoxUID"/>
								<xsl:with-param name="fontFamily" select="$FontFamily"/>
								<xsl:with-param name="fontSize" select="$fontSize"/>
								<xsl:with-param name="textIndent" select="$textIndent"/>
								<xsl:with-param name="textAlignment" select="$textAlignment"/>
								<xsl:with-param name="anchBox" select="$anchBox"/>
							</xsl:apply-templates>
						</xsl:if>
					</xsl:for-each>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!-- Add FORMAT tag related to text component -->
	<xsl:template name="FORMAT" match="FORMAT">
		<xsl:if test="not(BNSTYLE/@NAME='None')">
			<xsl:element name="span">
				<xsl:value-of select="BNSTYLE/@BNCHAR"/>
			</xsl:element>
			<xsl:element name="span">
				<xsl:attribute name="style"><xsl:choose><xsl:when test="/PROJECT/LAYOUT/@REFLOWSTORYDIRECTION = 'VERTICAL'"><xsl:value-of select="'padding-top:'"/></xsl:when><xsl:otherwise><xsl:value-of select="'padding-left:'"/></xsl:otherwise></xsl:choose><xsl:value-of select="'10px'"/></xsl:attribute>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<!-- Add RUN tag related to text component -->
	<xsl:template name="RICHTEXT" match="RICHTEXT">
		<xsl:param name="pageID" select="'$pageID'"/>
		<xsl:param name="isTyc" select="'$isTyc'"/>
		<xsl:variable name="localIsTyc">
			<xsl:choose>
				<xsl:when test="$isTyc = 'true'">
					<xsl:text disable-output-escaping="yes">true</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text disable-output-escaping="yes">false</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="textStyling">
			<xsl:if test="@BOLD">
				<xsl:text disable-output-escaping="yes">bold </xsl:text>
			</xsl:if>
			<xsl:if test="@ITALIC">
				<xsl:text disable-output-escaping="yes">italic </xsl:text>
			</xsl:if>
			<xsl:if test="(@STRIKETHRU='true' or @UNDERLINE='true') and $localIsTyc = 'false'">
				<xsl:choose>
					<xsl:when test="@STRIKETHRU='true' and @UNDERLINE='true'">
						<xsl:text disable-output-escaping="yes">strikethrough-and-underline </xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="@STRIKETHRU='true'">
							<xsl:text disable-output-escaping="yes">strikethrough </xsl:text>
						</xsl:if>
						<xsl:if test="@UNDERLINE='true'">
							<xsl:text disable-output-escaping="yes">underline </xsl:text>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="@SUPERSCRIPT">
				<xsl:text disable-output-escaping="yes">superscript </xsl:text>
			</xsl:if>
			<xsl:if test="@SUPERIOR">
				<xsl:text disable-output-escaping="yes">superior </xsl:text>
			</xsl:if>
			<xsl:if test="@SUBSCRIPT">
				<xsl:text disable-output-escaping="yes">subscript </xsl:text>
			</xsl:if>
		</xsl:variable>
		<xsl:element name="span">
			<!--xsl:attribute name="xml:lang"><xsl:value-of select="@TEXTRUNSCRIPT"/></xsl:attribute-->
			<xsl:if test="@LANGUAGE">
				<xsl:call-template name="AddISOLanguageCode">
					<xsl:with-param name="langaugeName" select="@LANGUAGE"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="'' != $textStyling">
				<xsl:attribute name="class"><xsl:value-of select="normalize-space($textStyling)"/></xsl:attribute>
			</xsl:if>
			<xsl:call-template name="RemoveEscapes"/>
		</xsl:element>
	</xsl:template>
	<!-- Search specified text and replaces text with passed text -->
	<xsl:template name="AddISOLanguageCode">
		<xsl:param name="langaugeName"/>
		<xsl:if test="$langaugeName = 'SwissGerman'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'de'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'SwissGermanReformed'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'de'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'BrazilianPortuguese'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'pt'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Bulgarian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'bg'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Croatian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'hr'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Czech'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'cs'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Dutch'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'de'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Danish'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'da'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Finnish'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'fi'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'French'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'fr'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'German'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'de'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'ReformedGerman'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'de'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Hungarian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'hu'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Greek'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'el'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Italian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'it'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Portuguese'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'pt'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Polish'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'pl'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Slovak'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'fr'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Russian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'ru'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Romanian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'ro'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Swedish'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'sv'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Spanish'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'es'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Turkish'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'tr'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'USEnglish'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'en-US'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Catalan'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'es'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Estonian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'et'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Slovenian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'sl'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Lithuanian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'lt'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Latvian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'en-US'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Icelandic'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'is'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'InternationalEnglish'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'en'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'SimplifiedChinese'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'zh'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'TraditionalChinese'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'zh'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Japanese'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'ja'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Korean'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'ko'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'Ukrainian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'uk'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'BokmalNorwegian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'no'"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$langaugeName = 'NynorskNorwegian'">
			<xsl:attribute name="xml:lang"><xsl:value-of select="'no'"/></xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template name="RUBY" match="RUBI">
		<xsl:param name="pageID" select="$pageID"/>
		<xsl:choose>
			<xsl:when test="/PROJECT/LAYOUT/@EXPORTRUBYAS = 'PARANTHESIS'">
				<xsl:element name="Ruby">
					<xsl:if test="RICHTEXT /@LANGUAGE">
						<xsl:call-template name="AddISOLanguageCode">
							<xsl:with-param name="langaugeName" select="RICHTEXT /@LANGUAGE"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:element name="rb">
						<xsl:apply-templates select="./RICHTEXT">
							<xsl:with-param name="pageID" select="$pageID"/>
						</xsl:apply-templates>
					</xsl:element>
					<xsl:element name="rp">
						<xsl:value-of select="'('"/>
					</xsl:element>
					<xsl:element name="rt">
						<xsl:apply-templates select="./RUBITEXT/RICHTEXT">
							<xsl:with-param name="pageID" select="$pageID"/>
						</xsl:apply-templates>
					</xsl:element>
					<xsl:element name="rp">
						<xsl:value-of select="')'"/>
					</xsl:element>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="rubyPosition">
					<xsl:if test="@PLACEMENT='ABOVE'">
						<xsl:text disable-output-escaping="yes">above</xsl:text>
					</xsl:if>
					<xsl:if test="@PLACEMENT='BELOW'">
						<xsl:text disable-output-escaping="yes">below</xsl:text>
					</xsl:if>
					<xsl:if test="@ALIGNMENT='INLINE'">
						<xsl:text disable-output-escaping="yes">inline</xsl:text>
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="rubyAlign">
					<xsl:if test="@ALIGNMENT='LEFT'">
						<xsl:text disable-output-escaping="yes">left</xsl:text>
					</xsl:if>
					<xsl:if test="@ALIGNMENT='CENTERED'">
						<xsl:text disable-output-escaping="yes">center</xsl:text>
					</xsl:if>
					<xsl:if test="@ALIGNMENT='RIGHT'">
						<xsl:text disable-output-escaping="yes">right</xsl:text>
					</xsl:if>
					<xsl:if test="@ALIGNMENT='JUSTIFIED'">
						<xsl:text disable-output-escaping="yes">distribute-letter</xsl:text>
					</xsl:if>
					<xsl:if test="@ALIGNMENT='FORCED'">
						<xsl:text disable-output-escaping="yes">distribute-letter</xsl:text>
					</xsl:if>
					<xsl:if test="@ALIGNMENT='ONETOONE'">
						<xsl:text disable-output-escaping="yes">distribute-space</xsl:text>
					</xsl:if>
					<xsl:if test="@ALIGNMENT='EQUALSPACE'">
						<xsl:text disable-output-escaping="yes">distribute-space</xsl:text>
					</xsl:if>
					<xsl:if test="@ALIGNMENT='ONERUBISPACE'">
						<xsl:text disable-output-escaping="yes">distribute-space</xsl:text>
					</xsl:if>
				</xsl:variable>
				<xsl:variable name="rubyOverhang">
					<xsl:if test="@OVERHANG='HALFRUBI'">
						<xsl:text disable-output-escaping="yes">whitespace</xsl:text>
					</xsl:if>
				</xsl:variable>
				<xsl:element name="ruby">
					<xsl:attribute name="style"><xsl:value-of select="concat('ruby-align:', $rubyAlign, '; ruby-position:',  $rubyPosition, '; ruby-overhang:', $rubyOverhang)"/></xsl:attribute>
					<xsl:if test="RICHTEXT /@LANGUAGE">
						<xsl:call-template name="AddISOLanguageCode">
							<xsl:with-param name="langaugeName" select="RICHTEXT /@LANGUAGE"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:apply-templates select="./RICHTEXT">
						<xsl:with-param name="pageID" select="$pageID"/>
					</xsl:apply-templates>
					<xsl:element name="rt">
						<xsl:apply-templates select="./RUBITEXT/RICHTEXT">
							<xsl:with-param name="pageID" select="$pageID"/>
						</xsl:apply-templates>
					</xsl:element>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
